CREATE TABLE s3_mds_file (
    id bigserial PRIMARY KEY,
    bucket text NOT NULL,
    name text NOT NULL,
    display_name text NOT NULL,
    created_at timestamptz NOT NULL default NOW(),
    updated_at timestamptz NOT NULL default NOW()
);

CREATE TABLE report_meta_info (
    id bigserial PRIMARY KEY,
    name text NOT NULL,
    agency_id bigint NOT NULL,
    period_from timestamptz NOT NULL,
    period_to timestamptz NOT NULL,
    clients_ids bigint[],
    status text NOT NULL,
    file_id bigint,
    created_at timestamptz NOT NULL default NOW(),
    updated_at timestamptz NOT NULL default NOW(),
    CONSTRAINT report_meta_info__file_id__fk FOREIGN KEY(file_id) REFERENCES s3_mds_file (id) ON DELETE CASCADE
);

CREATE INDEX report_meta_info__agency_id_idx ON report_meta_info (agency_id);
