from dataclasses import dataclass

__all__ = [
    "ClientNotFound",
    "ClientBonusException",
    "FileNotFoundException",
    "NoSuchReportException",
    "UnsuitableAgencyException",
    "ReportNotReadyException",
]


class ClientBonusException(Exception):
    pass


@dataclass
class ClientNotFound(ClientBonusException):
    client_id: int
    agency_id: int


class NoSuchReportException(ClientBonusException):
    pass


class UnsuitableAgencyException(ClientBonusException):
    pass


class FileNotFoundException(ClientBonusException):
    pass


class ReportNotReadyException(ClientBonusException):
    pass
