PY3TEST()

OWNER(
    g:agency_cabinet_back
)

SIZE(LARGE)

ENV(DATABASE_URL_FOR_TESTS=postgresql://client_bonuses:client_bonuses@localhost:5433/client_bonuses)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)


PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
    contrib/python/pytest-freezegun
    contrib/python/xlrd

    smb/common/multiruntime
    smb/common/pgswim/pytest
    smb/common/testing_utils

    crm/agency_cabinet/client_bonuses/server
    crm/agency_cabinet/common/testing
    smb/common/pgswim/pytest
    smb/common/testing_utils
)

PY_SRCS(
    __init__.py
    celery/__init__.py
    celery/load_bonuses_data/__init__.py
    handler/__init__.py
    handler/conftest.py
    procedures/__init__.py
    procedures/list_clients_bonuses/__init__.py
    procedures/list_clients_bonuses/conftest.py
    conftest.py
    factory.py
)

TEST_SRCS(
    celery/load_bonuses_data/test_loader.py
    celery/load_bonuses_data/test_bonuses_to_activate_loader.py
    celery/load_bonuses_data/test_bonuses_corrections_loader.py
    celery/load_bonuses_data/test_market_bonuses_loader.py
    celery/load_bonuses_data/test_client_bonuses_to_activate_table_synchronizer.py
    celery/load_bonuses_data/test_clients_programs_table_synchronizer.py
    celery/load_bonuses_data/test_clients_table_synchronizer.py
    celery/load_bonuses_data/test_gained_client_bonuses_table_synchronizer.py
    celery/load_bonuses_data/test_spent_client_bonuses_table_synchronizer.py
    celery/test_generate_report.py
    celery/load_cashback_programs/test_cashback_programs_table_synchronizer.py
    celery/load_cashback_programs/test_loader.py
    handler/test_list_clients_bonuses.py
    handler/test_list_bonuses_reports.py
    handler/test_fetch_bonuses_details.py
    handler/test_client_bonuses_graph.py
    handler/test_detailed_report_info.py
    handler/test_get_clients_bonuses_settings.py
    handler/test_get_report_url.py
    handler/test_create_bonuses_reports.py
    handler/test_list_cashback_programs.py
    handler/test_delete_bonuses_reports.py

    procedures/list_clients_bonuses/test_common.py
    procedures/list_clients_bonuses/test_filter_by_client_type.py
    procedures/list_clients_bonuses/test_filter_by_search_query.py
    procedures/test_client_bonuses_graph.py
    procedures/test_get_detailed_report_info.py
    procedures/test_get_report_url.py
    procedures/test_fetch_bonuses_details.py
)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

CONFTEST_LOAD_POLICY_LOCAL()

END()
