PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)


PEERDIR(
    contrib/python/Babel
    contrib/python/celery
    contrib/python/redis
    contrib/python/click
    library/python/ylock

    crm/agency_cabinet/client_bonuses/common
    crm/agency_cabinet/client_bonuses/proto
    crm/agency_cabinet/common/celery
    crm/agency_cabinet/common/config
    crm/agency_cabinet/common/server/rpc
    crm/agency_cabinet/common/service_discovery
    crm/agency_cabinet/common/definitions
    smb/common/helpers
    smb/common/multiruntime
    smb/common/pgswim
    yql/library/python
)


PY_SRCS(
    lib/__init__.py
    lib/handler.py
    lib/config/__init__.py
    lib/celery/__init__.py
    lib/celery/base.py
    lib/celery/tasks/__init__.py
    lib/celery/tasks/load_bonuses_data/__init__.py
    lib/celery/tasks/load_bonuses_data/synchronizers.py
    lib/celery/tasks/generate_report.py
    lib/celery/tasks/load_cashback_programs/__init__.py
    lib/celery/tasks/load_cashback_programs/loaders.py
    lib/celery/tasks/load_cashback_programs/synchronizers.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/exceptions.py
    lib/procedures.py
)

RESOURCE_FILES(
    PREFIX crm/agency_cabinet/client_bonuses/server

    lib/db/migrations/001_20210816/downgrade.sql
    lib/db/migrations/001_20210816/upgrade.sql
    lib/db/migrations/002_20211111/downgrade.sql
    lib/db/migrations/002_20211111/upgrade.sql
    lib/db/migrations/003_20211116/downgrade.sql
    lib/db/migrations/003_20211116/upgrade.sql
    lib/db/migrations/004_20211123/downgrade.sql
    lib/db/migrations/004_20211123/upgrade.sql
    lib/db/migrations/005_20211124/downgrade.sql
    lib/db/migrations/005_20211124/upgrade.sql
    lib/db/migrations/006_20211129/downgrade.sql
    lib/db/migrations/006_20211129/upgrade.sql
    lib/db/migrations/007_20211221/downgrade.sql
    lib/db/migrations/007_20211221/upgrade.sql
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(tests)
