from aiohttp.web_log import AccessLogger

from crm.agency_cabinet.common.request_id_utils import REQUEST_ID_VAR, USER_ID_VAR


class RequestIdContextAccessLogger(AccessLogger):
    def log(self, request, response, time):
        token_req_id = REQUEST_ID_VAR.set(request.get('request_id') or 'UNSET')
        token_user_id = USER_ID_VAR.set(request.get('yandex_uid') or 'UNSET')
        try:
            super().log(request, response, time)
        finally:
            USER_ID_VAR.reset(token_user_id)
            REQUEST_ID_VAR.reset(token_req_id)
