import functools
from cachetools import keys, TTLCache, RRCache, LRUCache, LFUCache, Cache
from crm.agency_cabinet.common.utils.nullcontext import NullContext


__all__ = [
    'cached',
    'TTLCache',
    'RRCache',
    'LRUCache',
    'LFUCache',
    'Cache'
]


def cached(cache: Cache, key=keys.hashkey, lock=NullContext()):
    def decorator(func):
        async def wrapper(*args, **kwargs):
            if cache is None:
                return await func(*args, **kwargs)
            k = key(*args, **kwargs)
            try:
                with lock:
                    return cache[k]
            except KeyError:
                pass  # key not found
            v = await func(*args, **kwargs)
            try:
                with lock:
                    cache[k] = v
            except ValueError:
                pass  # value too large
            return v

        wrapper.cache_clear = cache.clear

        return functools.update_wrapper(wrapper, func)
    return decorator
