import logging
from celery.signals import after_setup_logger, after_setup_task_logger, task_prerun, task_received, task_postrun
from crm.agency_cabinet.common.logging import DeployFormatter
from crm.agency_cabinet.common.server.common.logging_config import get_logging_config
from crm.agency_cabinet.common.request_id_utils import REQUEST_ID_VAR


@after_setup_task_logger.connect
def setup_task_logger(logger, *args, **kwargs):
    for handler in logger.handlers:
        handler.setFormatter(
            DeployFormatter()
        )


@after_setup_logger.connect
def setup_logger(logger, *args, **kwargs):
    logging.config.dictConfig(get_logging_config(True))
    for handler in logger.handlers:
        handler.setFormatter(
            DeployFormatter()
        )


@task_prerun.connect
def task_prerun(signal=None, sender=None, task_id=None, task=None, args=None, kwargs=None, *sargs, **skwarg):
    if task_id is not None:  # task_received и task_prerun могут быть в разных процессах
        REQUEST_ID_VAR.set(task_id)
    logger = logging.getLogger('celery')
    logger.info('Start %s', task.name)


@task_received.connect
def task_received(request=None, *args, **kwargs):
    if request is not None:
        REQUEST_ID_VAR.set(request.id)


@task_postrun.connect
def task_postrun(signal=None, sender=None, task_id=None, task=None,
                 args=None, kwargs=None, retval=None, state=None, *sargs, **skwarg):
    REQUEST_ID_VAR.set('UNSET')
