import typing

from re import compile
from yt.wrapper import YtClient


def validate_tasks_decorator(task_names: typing.Set, message_callback: typing.Callable = None):
    def dec(func):
        def wrapper(self, name, *args, **kwargs):
            if name not in task_names:
                if message_callback is None:
                    print('\033[93mTask not supported\033[0m')
                else:
                    message_callback()
                exit(0)
            return func(self, name, *args, **kwargs)
        return wrapper
    return dec


def extract_shard_names(base_path: str, client_config: dict[str]):
    yt_client = YtClient(
        proxy=client_config['cluster'],
        token=client_config['token'],
        config=client_config.get('config')
    )

    pattern = compile(f'^{base_path}/ppc:[0-9]+$')
    return (
        str(item_name)
        for item_name in yt_client.search(base_path, node_type=['map_node'])
        if pattern.match(str(item_name))
    )
