import logging
from typing import Tuple, Type

from google.protobuf.message import Message
from smb.common.rmq.rpc.client import RmqRpcClient

from .exceptions import ProtocolError

LOGGER = logging.getLogger('common.client')


class BaseClient:
    queue: str = None

    def __init__(self, rmq_rpc_client: RmqRpcClient):
        self._client = rmq_rpc_client
        LOGGER.info(f'Created client "{self.__class__.__name__}" with queue "{self.queue}"')

    async def _send_message(
            self, message: Message, response_message_type: Type[Message]
    ) -> Tuple[str, Message]:
        resp_pb = await self._client.send_proto_message(
            queue_name=self.queue,
            message=message,
            response_message_type=response_message_type,
        )

        try:

            field, data = resp_pb.ListFields()[0]
        except IndexError:
            raise ProtocolError

        return field.name, data
