import typing
import math
from crm.agency_cabinet.common.enum import BaseEnum


class AverageCheckBucket(BaseEnum):
    level_1 = '0-50'
    level_2 = '50-200'
    level_3 = '200+'

    @property
    def border(self) -> typing.Optional[float]:
        if self == AverageCheckBucket.level_1:
            return 50
        elif self == AverageCheckBucket.level_2:
            return 200
        return math.inf
