from crm.agency_cabinet.common.enum import BaseEnum


class PaymentType(BaseEnum):
    prepayment = 'prepayment'
    postpayment = 'postpayment'


class ContractType(BaseEnum):
    unknown = 'unknown'
    base = 'base'
    prof = 'prof'
    aggregator = 'aggregator'


class ReportContractType(BaseEnum):
    special = 'special'
    crisis = 'crisis'


ContractTypeMap = {
    ContractType.unknown: 0,
    ContractType.base: 1,
    ContractType.prof: 2,
    ContractType.aggregator: 3
}


def convert_contract_type(type: ContractType):
    return ContractTypeMap[type]
