from functools import cache
from crm.agency_cabinet.common.enum import BaseEnum


class Services(BaseEnum):
    media = 'media'
    direct = 'direct'
    zen = 'zen'
    video = 'video'
    sprav = 'sprav'
    business = 'business'
    early_payment = 'early_payment'

    @classmethod
    @cache
    def get_exception_services_list(cls):
        return {cls.early_payment, cls.sprav}


# TODO: Figure out what to do for this types
# 0 - No
# 11 - market
SERVICE_DISCOUNT_TYPE_MAP = {
    Services.direct.value: (7, ),
    Services.media.value: (1, 2, 3, 4, 13, 17, 24, 25, 37, 42),
    Services.video.value: (36, 45),
    Services.business.value: (12, 15, 99),
    Services.zen.value: (40,),
    Services.sprav.value: (),
}

DISCOUNT_TYPE_SERVICE_MAP = {}
for service, types in SERVICE_DISCOUNT_TYPE_MAP.items():
    for t in types:
        DISCOUNT_TYPE_SERVICE_MAP[t] = service


def service_id_to_name(service_id):
    return DISCOUNT_TYPE_SERVICE_MAP.get(service_id, None)


def name_to_service_id(service):
    return SERVICE_DISCOUNT_TYPE_MAP.get(service)
