import typing
import yenv
import platform
from gino.crud import CRUDModel
from gino import Gino
from sqlalchemy.dialects import registry

if yenv.type == 'development' and platform.system() == 'Darwin':
    # без этого не хотят тесты локально запускаться
    # из-за ошибки: Can't load plugin: sqlalchemy.dialects:postgresql.asyncpg
    registry.register("asyncpg", "gino.dialects.asyncpg", "AsyncpgDialect")
    registry.register("postgresql.asyncpg", "gino.dialects.asyncpg", "AsyncpgDialect")

db: typing.Optional[Gino] = None

# Оставляю как пример, возможно когда-то понадобится что-то кастомное делать
# class _Update:
#     def __get__(self, instance, owner):
#         if instance is None:
#             # noinspection PyProtectedMember
#             owner._check_abstract()
#             if 'updated_at' in owner.__table__.columns:
#                 q = owner.__table__.update(values={'updated_at': utc_now()})
#             else:
#                 q = owner.__table__.update()
#             return q.execution_options(model=weakref.ref(owner))
#         else:
#             # noinspection PyProtectedMember
#             return instance._update
#
#
# class CRUDModelEnhanced(CRUDModel):
#     update = _Update()
#
#     def _update(self, **values):
#         if hasattr(self, 'updated_at') and 'updated_at' not in values:
#             values['updated_at'] = utc_now()
#         return self._update_request_cls(self).update(**values)


class GinoEnhanced(Gino):
    model_base_classes = (CRUDModel, )


def get_or_create_from_config(gino_config=None, gino_cls=GinoEnhanced) -> Gino:
    global db
    if db is not None:
        return db
    if gino_config is None:
        gino_config = {'naming_convention': {
            'ix': '%(table_name)__%(column_0_name)s_idx',
            'uq': 'uq_%(table_name)s_%(column_0_name)s',
            'ck': 'ck_%(table_name)s_%(constraint_name)s',
            'fk': 'fk_%(table_name)s_%(column_0_name)s_%(referred_table_name)s',
            'pk': 'pk_%(table_name)s'
        }}
    db = gino_cls(**gino_config)
    return db
