import typing


class NamedTemporaryFileProtocol(typing.Protocol):
    file: typing.IO[typing.AnyStr]
    name: str
    delete: bool

    def __enter__(self) -> 'NamedTemporaryFileProtocol':
        pass

    def __exit__(self, *args, **kwargs) -> typing.Optional[bool]:
        pass

    def close(self):
        pass

    def __iter__(self) -> typing.Iterator[typing.AnyStr]:
        pass

    def fileno(self) -> int:
        pass

    def flush(self):
        pass

    def isatty(self) -> bool:
        pass

    def read(self, n: int = ...) -> typing.AnyStr:
        pass

    def readable(self) -> bool:
        pass

    def readline(self, limit: int = ...) -> typing.AnyStr:
        pass

    def readlines(self, hint: int = ...) -> list[typing.AnyStr]:
        pass

    def seek(self, offset: int, whence: int = ...) -> int:
        pass

    def seekable(self) -> bool:
        pass

    def tell(self) -> int:
        pass

    def truncate(self, size: typing.Optional[int] = ...) -> int:
        pass

    def writable(self) -> bool:
        pass

    def write(self, s: typing.AnyStr) -> int:
        pass

    def writelines(self, lines: typing.Iterable[typing.AnyStr]):
        pass
