import typing
from .base import BaseEnum

ENUM_TYPE = typing.TypeVar('ENUM_TYPE', bound=BaseEnum)


def get_enum_from_str(val: typing.Union[str, ENUM_TYPE], enum_cls: typing.Type[ENUM_TYPE],
                      exception_cls: typing.Type[Exception] = None) -> typing.Optional[ENUM_TYPE]:
    if isinstance(val, str):
        try:
            val = enum_cls(val)
        except ValueError:
            if exception_cls is not None:
                raise exception_cls()
            return
    return val
