import ujson

from library.python.deploy_formatter import DeployFormatter as BaseDeployFormatter
from ylog.context import get_log_context


class DeployFormatter(BaseDeployFormatter):
    COMMON_FIELDS = (
        ('levelname', 'levelStr'),
        ('levelno', 'level'),
        ('asctime', '@timestamp'),
        ('name', 'loggerName'),
        ('threadName', 'threadName'),
        ('message', 'message'),
        ('request_id', 'request_id'),
        ('user_id', 'user_id')
    )

    KNOWN_KEYS = {
        'name', 'msg', 'message', 'args', 'levelname',
        'levelno', 'pathname', 'filename', 'module',
        'exc_info', 'exc_text', 'lineno', 'funcName',
        'created', 'msecs', 'relativeCreated', 'thread',
        'threadName', 'processName', 'process', 'asctime',
        'request_id',  # 'user_id'
    }

    def format(self, record):
        record.message = record.getMessage()
        record.asctime = self.formatTime(record)

        msg = {}
        log_context_fields = get_log_context()

        for field, dest_name in self.COMMON_FIELDS:
            if log_context_fields and field in log_context_fields:  # в первую очередь берем из контекста
                msg[dest_name] = log_context_fields.pop(field)
            elif hasattr(record, field):
                msg[dest_name] = getattr(record, field)

        msg['@fields'] = {}
        for field, dest_name in self.COMMON_CONTEXT_FIELDS:
            if log_context_fields and field in log_context_fields:
                msg['@fields'][dest_name] = log_context_fields.pop(field)
            elif hasattr(record, field):
                msg['@fields'][dest_name] = getattr(record, field)

        for k, v in record.__dict__.items():
            if k not in self.KNOWN_KEYS and v is not None and v != '':
                msg['@fields'][k] = v

        if log_context_fields:
            msg['@fields']['custom'] = log_context_fields

        if record.exc_info and not record.exc_text:
            record.exc_text = self.formatException(record.exc_info)
        if record.exc_text:
            msg['stackTrace'] = record.exc_text

        return ujson.dumps(msg)
