import typing
import logging
from botocore.exceptions import ClientError
from crm.agency_cabinet.common.mds.definitions import S3Client, S3AsyncClient

LOGGER = logging.getLogger('mds.utils')


async def create_presigned_url_async(s3_client: S3AsyncClient,
                                     bucket_name: str,
                                     object_name: str, expiration: int = 3600) -> typing.Optional[str]:
    try:
        response = await s3_client.generate_presigned_url('get_object',
                                                          Params={'Bucket': bucket_name, 'Key': object_name},
                                                          ExpiresIn=expiration)
    except ClientError as e:
        LOGGER.error(e)
        return None

    return response


def create_presigned_url(s3_client: S3Client,
                         bucket_name:
                         str, object_name: str, expiration: int = 3600) -> typing.Optional[str]:
    try:
        response = s3_client.generate_presigned_url('get_object',
                                                    Params={'Bucket': bucket_name, 'Key': object_name},
                                                    ExpiresIn=expiration)
    except ClientError as e:
        LOGGER.error(e)
        return None

    return response


def create_public_url(bucket_name: str, object_name: str, base_url: str = 's3.yandex.net') -> str:
    return f'https://{bucket_name}.{base_url}/{object_name}'
