import typing
import click

from library.python.monitoring.solo.helpers.cli import basic_run_v2


def cli_factory(
    tokens_secret_id: str,
    objects_registry_callable: typing.Callable[[str], list],
    juggler_mark_callable: typing.Callable[[str], typing.Optional[str]],
    state_locke_path_callable: typing.Callable[[str], typing.Optional[str]],
    state_file_path: str = None
) -> typing.Callable:
    @click.command()
    @click.option("--apply-changes", is_flag=True, help="apply changes on the run")
    @click.option("--verbose", is_flag=True, help="turn on verbose logging")
    @click.option("--env_type", type=click.Choice(['test', 'prod']), default='prod', help="Solomon environment", )
    @click.option("--delete-untracked", is_flag=True, help="delete untracked objects")
    @click.option("--clear-untracked-in-state", is_flag=True, help="clear untracked in state, do not delete")
    def cli(apply_changes, verbose, env_type, delete_untracked, clear_untracked_in_state):
        basic_run_v2(
            objects_registry=objects_registry_callable(env_type),
            juggler_mark=juggler_mark_callable(env_type),
            state_locke_path=state_locke_path_callable(env_type),
            delete_untracked=delete_untracked,
            clear_untracked_in_state=clear_untracked_in_state,
            tokens_secret_id=tokens_secret_id,
            apply_changes=apply_changes,
            verbose=verbose,
            state_file_path=state_file_path
        )
    return cli
