from library.python.monitoring.solo.objects.solomon.v2 import Cluster, YpCluster
from crm.agency_cabinet.common.monitoring.project import agency_cabinet_solomon_project as project

testing = Cluster(
    id=f'{project.id}_testing',
    name='testing',
    project_id=project.id,
    yp_clusters={
        YpCluster(pod_set_id="agency-cabinet-backend-testing.rewards", cluster="sas", labels={"env=testing", "app=rewards"}),
        YpCluster(pod_set_id="agency-cabinet-backend-testing.grants", cluster="sas", labels={"env=testing", "app=grants"}),
        YpCluster(pod_set_id="agency-cabinet-backend-testing.gateway", cluster="sas", labels={"env=testing", "app=gateway"}),
        YpCluster(pod_set_id="agency-cabinet-backend-testing.agencies", cluster="sas", labels={"env=testing", "app=agencies"}),
    },
)

prestable = Cluster(
    id=f'{project.id}_prestable',
    name='prestable',
    project_id=project.id,
    yp_clusters={
        YpCluster(pod_set_id="agency-cabinet-backend-prestable.rewards", cluster="iva", labels={"env=prestable", "app=rewards"}),
        YpCluster(pod_set_id="agency-cabinet-backend-prestable.grants", cluster="iva", labels={"env=prestable", "app=grants"}),
        YpCluster(pod_set_id="agency-cabinet-backend-prestable.gateway", cluster="iva", labels={"env=prestable", "app=gateway"}),
        YpCluster(pod_set_id="agency-cabinet-backend-prestable.agencies", cluster="iva", labels={"env=prestable", "app=agencies"}),
    },
)

prod = Cluster(
    id=f'{project.id}_prod',
    name='prod',
    project_id=project.id,
    yp_clusters={
        YpCluster(pod_set_id="agency-cabinet-backend-production.rewards", cluster="sas", labels={"env=prod", "app=rewards"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.grants", cluster="sas", labels={"env=prod", "app=grants"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.gateway", cluster="sas", labels={"env=prod", "app=gateway"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.agencies", cluster="sas", labels={"env=prod", "app=agencies"}),

        YpCluster(pod_set_id="agency-cabinet-backend-production.rewards", cluster="iva", labels={"env=prod", "app=rewards"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.grants", cluster="iva", labels={"env=prod", "app=grants"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.gateway", cluster="iva", labels={"env=prod", "app=gateway"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.agencies", cluster="iva", labels={"env=prod", "app=agencies"}),

        YpCluster(pod_set_id="agency-cabinet-backend-production.rewards", cluster="myt", labels={"env=prod", "app=rewards"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.grants", cluster="myt", labels={"env=prod", "app=grants"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.gateway", cluster="myt", labels={"env=prod", "app=gateway"}),
        YpCluster(pod_set_id="agency-cabinet-backend-production.agencies", cluster="myt", labels={"env=prod", "app=agencies"}),
    },
)

register = [testing, prestable, prod]
