from library.python.monitoring.solo.objects.solomon.sensor import Sensor, Kind
from library.python.monitoring.solo.objects.solomon.v2 import Service, Cluster
from crm.agency_cabinet.common.monitoring.project import agency_cabinet_solomon_project as project


def get_service_uptime(cluster: Cluster, service: Service,):
    return Sensor(
        project=project.id,
        cluster=cluster.name,
        service=service.name,
        sensor='server.uptime_seconds'
    )


def get_service_response_time(cluster: Cluster, service: Service,):
    return Sensor(
        project=project.id,
        cluster=cluster.name,
        service=service.name,
        kind=Kind.HIST,
        sensor='server.response_time_milliseconds'
    )


def get_service_http_response_rate(cluster: Cluster, service: Service,):
    return [
        Sensor(
            project=project.id,
            cluster=cluster.name,
            service=service.name,
            sensor='http.ok'
        ),
        Sensor(
            project=project.id,
            cluster=cluster.name,
            service=service.name,
            sensor='http.client_error'
        ),
        Sensor(
            project=project.id,
            cluster=cluster.name,
            service=service.name,
            sensor='http.server_error'
        ),
    ]


def get_service_http_response_rate_by_status(cluster: Cluster, service: Service):
    return Sensor(
        project=project.id,
        cluster=cluster.name,
        service=service.name,
        sensor='http.requests'
    )
