import crm.agency_cabinet.common.monitoring.clusters as clusters
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from library.python.monitoring.solo.objects.solomon.v2 import Cluster


def build_sqs_message_count_sensor(cluster: Cluster) -> Sensor:

    user_map = {
        clusters.testing: 'agency-cabinet-dev',
        clusters.prod: 'agency-cabinet',
        clusters.prestable: 'agency-cabinet-test'
    }

    return Sensor(
        project='kikimr',
        cluster='sqs',
        host='cluster',
        user=user_map[cluster],
        sensor='MessagesCount',
        slot='-|static',
        service='kikimr_sqs'
    )
