import contextvars
import uuid

REQUEST_ID_HEADER_NAME = "X-Request-ID"
REQUEST_ID_VAR = contextvars.ContextVar("request_id", default="UNSET")


def generate_request_id() -> str:
    return str(uuid.uuid4())


def set_request_id_header(response):
    response.headers[REQUEST_ID_HEADER_NAME] = REQUEST_ID_VAR.get()
