import os
import sys
import ylock
from time import sleep  # noqa
from logging import StreamHandler, DEBUG
from ylock.backends.yt import logger
from crm.agency_cabinet.common.lock import monkey_patch
from crm.agency_cabinet.rewards.server.src.celery import celery


if __name__ == '__main__':
    celery.Beat().run()
    monkey_patch()

    manager = ylock.create_manager(
        backend='yt',
        proxy='freud',
        token=os.environ['YT_TOKEN'],
    )

    lock = manager.lock('lock_agency_cab', block=False, block_timeout=None, timeout=25)
    lock2 = manager.lock('lock_agency_cab', block=False, block_timeout=None, timeout=25)
    h = StreamHandler(sys.stdout)
    h.setLevel(DEBUG)
    logger.setLevel(DEBUG)
    logger.addHandler(h)
    print('Try to acquire lock: ', lock.acquire())
    print('Check if lock acquired by somebody', lock2.check_acquired())
    print('Try to acquire second lock: ', lock2.acquire())
    print('Check if lock acquired by lock', lock.is_acquired())
    print('Check if lock not acquired by second lock', lock2.is_acquired())
    print('Try to release not acquired second lock', lock2.release())
    print('Check if lock still exists: ', lock.check_acquired())
    print('Check first lock is still acquired: ', lock.is_acquired())
    # sleep(10)
    print('Release first lock', lock.release())
    print('Check if lock released', lock.is_acquired())
    print('Check if lock not acuqired by first lock', lock.is_acquired())
