from crm.agency_cabinet.rewards.server.config import DATABASE_SETTINGS
from crm.agency_cabinet.rewards.server.src.db.engine import db
from crm.agency_cabinet.rewards.server.src.celery.tasks.deprecated.rewards_2021.load_rewards import MonthRewardLoader, ProfMonthRewardLoader, ServiceReward, YT_CONFIG

if __name__ == '__main__':
    db_bind = db.with_bind(bind=DATABASE_SETTINGS['dsn'],
                           pool_class=DATABASE_SETTINGS['pool_class'])
    tablepath = '//home/balance/prod/yb-ar/rewards/yandex/2021-prof_20-m-2021_m_prof/202104'
    m = ProfMonthRewardLoader(
        tablepath,
        ServiceReward,
        {
            'reward_id': '_get_reward_id',
            'revenue': 'amt',
            'discount_type': 'discount_type',
            'payment': 'reward',
            'service': '_get_service'
        },
        {

        },
        {
            'cluster': 'hahn',
            'token': YT_CONFIG['TOKEN'],
            'config': {}
        },
        db_bind,
        limit=10
    )
    m.load()
    print('DONE')

    tablepath = '//home/balance/prod/yb-ar/rewards/yandex/2021-base-m-2021_m_base/202104'
    m = MonthRewardLoader(
        tablepath,
        ServiceReward,
        {
            'reward_id': '_get_reward_id',
            'revenue': 'amt',
            'discount_type': 'discount_type',
            'payment': 'reward',
            'service': '_get_service'
        },
        {

        },
        {
            'cluster': 'hahn',
            'token': YT_CONFIG['TOKEN'],
            'config': {}
        },
        db_bind,
        limit=10
    )
    m.load()
    print('DONE')
