# -*- coding: utf-8 -*-
from typing import Dict, Callable
from aiohttp import web


async def app_factory(handlers: Dict[str, Callable]) -> web.Application:
    # TODO: write class?
    app = web.Application()
    for route, handler in handlers.items():
        app.add_routes([web.get(route, handler)])
    return app


def run_server_base(handlers: Dict[str, Callable]) -> None:
    web.run_app(app_factory(handlers))
