import os
import environ


@environ.config
class ServerConfig:
    amqp_url = environ.var()
    development_mode = environ.bool_var(default=False)
    verbose = environ.bool_var(default=False)


DEFAULT_EXTERNAL_ENDPOINT_URL = os.environ.get('MDS_ENDPOINT_URL')


@environ.config(prefix='MDS')
class MdsConfig:
    endpoint_url = environ.var()
    # use default value from another environ var; TODO: better?
    external_endpoint_url = environ.var(default=DEFAULT_EXTERNAL_ENDPOINT_URL)
    access_key_id = environ.var()
    secret_access_key = environ.var()
    bucket = 'agency-cabinet-common'
