import re
from transliterate import translit
from typing import Callable, List, TypeVar

T = TypeVar('T')


def list_converter(converter: Callable[[str], T]) -> Callable[[str], List[T]]:
    def _convert(value: str) -> List[T]:
        if not value:
            return []
        parts = value.split(',')
        return [converter(part.strip()) for part in parts]
    return _convert


def coderfy_string(text):
    cleaned = re.sub(r'[-()\'#/@;:<>$%^&*{}`+=~|.!?, ]', '', text.lower())
    return translit(cleaned, 'ru', reversed=True)
