import logging
from functools import cache
from crm.agency_cabinet.common.request_id_utils import REQUEST_ID_VAR, USER_ID_VAR


@cache
def setup_logging_request_and_user_id():
    factory = logging.getLogRecordFactory()

    def injected_ids_factory(*args, **kwargs):
        record = factory(*args, **kwargs)
        req_id = REQUEST_ID_VAR.get()
        user_id = USER_ID_VAR.get()
        record.request_id = req_id
        record.user_id = str(user_id) if user_id else ''
        return record

    logging.setLogRecordFactory(injected_ids_factory)


def get_logging_config(verbose: bool, should_setup_logging_req_and_user_id: bool = True, use_default_formatter=False) -> dict:

    config = {
        'version': 1,
        'disable_existing_loggers': False,
        'filters': {},
        'formatters': {
            'default': {
                'format': '%(asctime)s %(levelname)s:%(name)s %(message)s [File \"%(pathname)s\", line %(lineno)d]',
                'datefmt': '%Y-%m-%d %H:%M:%S',
                'class': 'logging.Formatter',
            },
            'json': {
                '()': 'ylog.format.QloudJsonFormatter',
            },
            'pretty_deploy': {
                '()': 'crm.agency_cabinet.common.logging.DeployFormatter',
            },
        },
        'handlers': {
            'default': {
                'class': 'logging.StreamHandler',
                'formatter': 'default',
            },
            'deploy': {
                'class': 'logging.StreamHandler',
                'formatter': 'pretty_deploy',
            },
        },
        'loggers': {
            '': {
                'level': logging.DEBUG if verbose else logging.WARNING,
                'handlers': ['deploy' if not use_default_formatter else 'default'],
            }
        },
    }
    if should_setup_logging_req_and_user_id:
        setup_logging_request_and_user_id()
    return config
