import pytest

from unittest.mock import AsyncMock
from unittest.mock import create_autospec
from crm.agency_cabinet.common.blackbox import BlackboxClient


@pytest.fixture
async def tvm_client():
    class TvmClientMock:
        parse_service_ticket = AsyncMock()
        parse_user_ticket = AsyncMock()
        get_service_ticket = AsyncMock()

    return TvmClientMock()


@pytest.fixture
async def blackbox_client():
    return create_autospec(BlackboxClient)
