from crm.agency_cabinet.common.enum import BaseEnum
from dataclasses import dataclass

from crm.agency_cabinet.common.server.common.proto import common_pb2
from smb.common.helpers import Converter


class SortTypes(BaseEnum):
    desc = 'desc'
    asc = 'asc'


sort_types_converter = Converter(
    [
        (common_pb2.SortType.DESC, SortTypes.desc),
        (common_pb2.SortType.ASC, SortTypes.asc),
    ]
)


class TaskStatuses(BaseEnum):
    ready = 'ready'
    in_progress = 'in_progress'
    requested = 'requested'
    error = 'error'


task_status_converter = Converter(
    [
        (common_pb2.TaskStatuses.READY, TaskStatuses.ready),
        (common_pb2.TaskStatuses.IN_PROGRESS, TaskStatuses.in_progress),
        (common_pb2.TaskStatuses.REQUESTED, TaskStatuses.requested),
        (common_pb2.TaskStatuses.ERROR, TaskStatuses.error),
    ]
)


@dataclass
class UrlResponse:
    url: str

    @classmethod
    def from_proto(cls, message: common_pb2.Url) -> 'UrlResponse':
        return cls(url=message.url)

    def to_proto(self) -> common_pb2.Url:
        return common_pb2.Url(url=self.url)
