from tvmauth import BlackboxTvmId
from tvm2 import TVM2
from tvm2.ticket import ServiceTicket, UserTicket
from typing import Protocol

from .config import Tvm2Config


class TvmClient(Protocol):
    async def parse_service_ticket(self, ticket) -> ServiceTicket:
        ...

    async def parse_user_ticket(self, ticket) -> UserTicket:
        ...

    async def get_service_ticket(self, destination) -> str:
        ...


def get_tvm_client(config: Tvm2Config) -> TvmClient:
    kwargs = {
        'client_id': config.client_id,
        'blackbox_client': BlackboxTvmId.Test,
        'allowed_clients': '*'
    }
    if not config.use_daemon:
        kwargs.update({
            'secret': config.secret,
            'destinations': config.destinations
        })
    return TVM2(**kwargs)
