import environ
from sqlalchemy.engine.url import URL
from crm.agency_cabinet.common.server.common.config import ServerConfig


@environ.config
class DbConfig:
    user = environ.var(name='PG_LOCAL_USER', default='postgres')
    password = environ.var(name='PG_LOCAL_PASSWORD', default='postgres')
    host = environ.var(name='PG_LOCAL_HOST', default='localhost')
    port = environ.var(name='PG_LOCAL_PORT', default=5432)
    database = environ.var(name='PG_LOCAL_DATABASE', default='postgres')

    def get_dsn(self):
        return URL(
            drivername='postgresql',
            username=self.user,
            password=self.password,
            host=self.host,
            port=self.port,
            database=self.database
        )


@environ.config(prefix='')
class RpcServerConfig(ServerConfig):
    db = environ.group(DbConfig)


@environ.config(prefix='')
class DsnServerConfig(ServerConfig):
    pg_dsn = environ.var()
    pg_local_password = environ.var()

    def get_dsn(self):
        # пароль достается из секретницы, поэтому его читаем отдельно
        return self.pg_dsn.format(password=self.pg_local_password)
