import pytest
from crm.agency_cabinet.agencies.client import AgenciesClient
from crm.agency_cabinet.certificates.client import Client as CertificatesClient
from crm.agency_cabinet.client_bonuses.client import Client as ClientBonusesClient
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.documents.client import DocumentsClient
from crm.agency_cabinet.grants.client import GrantsClient
from crm.agency_cabinet.rewards.client import RewardsClient
from crm.agency_cabinet.ord.client import OrdClient
from smb.common.rmq.rpc.client import RmqRpcClient

pytest_plugins = [
    "crm.agency_cabinet.agencies.client.pytest.plugin",
    "crm.agency_cabinet.certificates.client.pytest.plugin",
    "crm.agency_cabinet.client_bonuses.client.pytest.plugin",
    "crm.agency_cabinet.grants.client.pytest.plugin",
    "crm.agency_cabinet.rewards.client.pytest.plugin",
    "crm.agency_cabinet.documents.client.pytest.plugin",
    "crm.agency_cabinet.ord.client.pytest.plugin",
    "smb.common.rmq.rpc.pytest.plugin",
]


@pytest.fixture
def service_discovery(
    rmq_rpc_client: RmqRpcClient,
    agencies_client: AgenciesClient,
    grants_client: GrantsClient,
    rewards_client: RewardsClient,
    client_bonuses_client: ClientBonusesClient,
    certificates_client: CertificatesClient,
    documents_client: DocumentsClient,
    ord_client: OrdClient
):
    class ServiceDiscoveryMock(ServiceDiscovery):
        @property
        def rpc_client(self):
            return rmq_rpc_client

        def __init__(self):
            self.agencies = agencies_client
            self.certificates = certificates_client
            self.client_bonuses = client_bonuses_client
            self.grants = grants_client
            self.rewards = rewards_client
            self.documents = documents_client
            self.ord = ord_client

    return ServiceDiscoveryMock()
