import typing


def flatten_dict(dictionary: typing.MutableMapping, base_key: str = '', sep: str = '.') -> typing.MutableMapping:
    result = dict()
    for k, v in dictionary.items():
        key = str(base_key) + sep + str(k) if base_key else k
        if isinstance(v, dict):
            result.update(flatten_dict(v, key))
        else:
            result[key] = v
    return result
