import random


def map_char(char: str):
    if '0' <= char <= '9':
        return chr((ord(char) - ord('0') + 1) % 10 + ord('0'))
    elif 'a' <= char <= 'z':
        return chr((ord(char) - ord('a') - 1) % 26 + ord('a'))
    elif 'A' <= char <= 'Z':
        return chr((ord(char) - ord('a') + 1) % 26 + ord('a'))
    elif 'а' <= char <= 'я':
        return chr((ord(char) - ord('а') + 1) % 32 + ord('а'))
    elif 'А' <= char <= 'Я':
        return chr((ord(char) - ord('А') - 1) % 32 + ord('А'))
    return char


def obfuscate_data(value):
    if isinstance(value, str):
        return ''.join([map_char(char) for char in value])  # shift alphanum letter +- 1
    elif isinstance(value, (int, float)):
        multiplier = 0.4 * random.random() + 0.7  # uniform dist on [0.7, 1.1]
        return value * multiplier
