import logging
from functools import cached_property
from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder

from crm.agency_cabinet.common.consts.reward import RewardsTypes
from crm.agency_cabinet.common.yt.base import YtModelLoader, YqlColumnExtractor

LOGGER = logging.getLogger('yql.loader')


class YqlModelLoader(YtModelLoader):
    def _init(self, yql_token: str, yql_query: str, yql_parameters=None, reward_type: RewardsTypes = None):
        self.yql_token = yql_token
        self.yql_query = yql_query

        if yql_parameters is None:
            yql_parameters = dict()

        self.yql_parameters = yql_parameters
        self.reward_type = reward_type

    @cached_property
    def yql_column_extractor(self):
        return YqlColumnExtractor(self._columns)

    def _get_column_value(self, row, column: str):
        return self.yql_column_extractor(yt_row=row, loader=self, column=column)

    def _read_table(self, **kwargs):
        yql_client = YqlClient(token=self.yql_token)
        request = yql_client.query(self.yql_query.format())

        request.run(parameters=YqlParameterValueBuilder.build_json_map(self.yql_parameters))
        results = request.get_results()

        if results.status == 'ERROR':
            LOGGER.error('YQL failed: %s', results.text)
            return

        if not results:
            LOGGER.error('YQL result is empty')
            return

        self._table = results.table.get_iterator()
        self._columns = results.table.column_names
