import datetime

from asgiref.sync import sync_to_async

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from yt.wrapper import YtClient

from .base import BaseLoader


class YqlLoader(BaseLoader):

    YQL_QUERY = None

    def yql_query(self):
        if not self.YQL_QUERY:
            raise Exception(f'There is no YQL_QUERY for {self.__class__}')

        return self.YQL_QUERY

    def __init__(self, yt_client: YtClient, yql_client: YqlClient, yql_parameters=None, table_paths: list[str] = None):
        super(YqlLoader, self).__init__(yt_client)
        self._yql_client = yql_client
        self._yql_parameters = yql_parameters if yql_parameters else {}
        self._table_paths = sorted([self._prepare_table_path(path) for path in table_paths])

    def _get_ytsync_path(self) -> str:
        return ','.join([path.lstrip('/') for path in self._table_paths])

    def _retrieve_tables_updated_at(self):
        # TODO: use try except/util.parse
        return max(
            datetime.datetime.strptime(
                self._yt_client.get(f'{table_path}@{self.table_update_attr}'), '%Y-%m-%dT%H:%M:%S.%fZ'
            ).astimezone(tz=datetime.timezone.utc)
            for table_path in self._table_paths
        )

    async def _get_results(self):
        @sync_to_async
        def get_results():
            request = self._yql_client.query(self.yql_query())
            request.run(parameters=YqlParameterValueBuilder.build_json_map(self._yql_parameters))
            return request.get_results()

        results = await get_results()
        if results.status == 'ERROR':
            raise Exception(f'YQL failed: {results.text}')
        return results
