"""init

Revision ID: b939917de4d3
Revises:
Create Date: 2021-12-01 08:18:49.078011+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform



# revision identifiers, used by Alembic.
revision = 'b939917de4d3'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'

    op.execute('CREATE SCHEMA IF NOT EXISTS documents')

    op.create_table('contract',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('eid', sa.Text(collation=collation), nullable=False),
                    sa.Column('inn', sa.Text(), nullable=False),
                    sa.Column('agency_id', sa.BigInteger(), nullable=False),
                    sa.Column('payment_type', sa.Text(), nullable=True),
                    sa.Column('signing_date', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('finish_date', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('credit_limit', sa.Numeric(precision=18, scale=6), nullable=True),
                    sa.Column('services', sa.ARRAY(sa.String()), nullable=True),
                    sa.Column('status', sa.Text(), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()')),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('contract__pk')),
                    sa.UniqueConstraint('eid', name=op.f('contract__eid__uq')),
                    schema='documents'
                    )
    op.create_index('contract__agency_id_idx', 'contract', ['agency_id'], unique=False, schema='documents')
    op.create_index('contract__eid_idx', 'contract', ['eid'], unique=True, schema='documents')
    op.create_table('tools_yt_sync',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('path', sa.Text(), nullable=True),
                    sa.Column('tag', sa.Text(), nullable=True),
                    sa.Column('last_used_update', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('enabled', sa.Boolean(), server_default='t', nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('tools_yt_sync__pk')),
                    schema='documents'
                    )
    op.create_index('tools_yt_sync__path_tag__idx', 'tools_yt_sync', ['path', 'tag'], unique=True, schema='documents')
    op.create_table('invoice',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('contract_id', sa.BigInteger(), nullable=False),
                    sa.Column('eid', sa.Text(collation=collation), nullable=False),
                    sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=False),
                    sa.Column('currency', sa.Text(), nullable=False),
                    sa.Column('status', sa.Text(), nullable=False),
                    sa.Column('date', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('payment_date', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['contract_id'], ['documents.contract.id'], name=op.f('invoice_contract__contract_id__fk'), ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id', name=op.f('invoice__pk')),
                    sa.UniqueConstraint('eid', name=op.f('invoice__eid__uq')),
                    schema='documents'
                    )
    op.create_index('invoice__eid_idx', 'invoice', ['eid'], unique=True, schema='documents')
    op.create_table('act',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('invoice_id', sa.BigInteger(), nullable=False),
                    sa.Column('eid', sa.Text(), nullable=False),
                    sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=False),
                    sa.Column('currency', sa.Text(), nullable=False),
                    sa.Column('date', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['invoice_id'], ['documents.invoice.id'], name=op.f('act_invoice__invoice_id__fk'), ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id', name=op.f('act__pk')),
                    sa.UniqueConstraint('eid', name=op.f('act__eid__uq')),
                    schema='documents'
                    )
    op.create_index('act__eid_idx', 'act', ['eid'], unique=True, schema='documents')
    op.create_table('factura',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('invoice_id', sa.BigInteger(), nullable=False),
                    sa.Column('date', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=False),
                    sa.Column('amount_with_nds', sa.Numeric(precision=18, scale=6), nullable=False),
                    sa.Column('nds', sa.Numeric(precision=18, scale=6), nullable=False),
                    sa.Column('currency', sa.Text(), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['invoice_id'], ['documents.invoice.id'], name=op.f('factura_invoice__invoice_id__fk'), ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id', name=op.f('factura__pk')),
                    sa.UniqueConstraint('invoice_id', name=op.f('factura__invoice_id__uq')),
                    schema='documents'
                    )
    op.create_table('payment',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('eid', sa.Text(), nullable=False),
                    sa.Column('invoice_id', sa.BigInteger(), nullable=False),
                    sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=False),
                    sa.Column('currency', sa.Text(), nullable=False),
                    sa.Column('date', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['invoice_id'], ['documents.invoice.id'], name=op.f('payment_invoice__invoice_id__fk'), ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id', name=op.f('payment__pk')),
                    schema='documents'
                    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('payment', schema='documents')
    op.drop_table('factura', schema='documents')
    op.drop_index('act__eid_idx', table_name='act', schema='documents')
    op.drop_table('act', schema='documents')
    op.drop_index('invoice__eid_idx', table_name='invoice', schema='documents')
    op.drop_table('invoice', schema='documents')
    op.drop_index('tools_yt_sync__path_tag__idx', table_name='tools_yt_sync', schema='documents')
    op.drop_table('tools_yt_sync', schema='documents')
    op.drop_index('contract__eid_idx', table_name='contract', schema='documents')
    op.drop_index('contract__agency_id_idx', table_name='contract', schema='documents')
    op.drop_table('contract', schema='documents')

    op.execute('DROP SCHEMA documents')
    # ### end Alembic commands ###
