"""added new model - agreement

Revision ID: 09d52d03f63b
Revises: b939917de4d3
Create Date: 2021-12-09 09:55:40.097610+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '09d52d03f63b'
down_revision = 'b939917de4d3'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'

    op.create_table('agreement',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('contract_id', sa.BigInteger(), nullable=True),
    sa.Column('name', sa.Text(collation=collation), nullable=False),
    sa.Column('got_scan', sa.Boolean(), nullable=False),
    sa.Column('got_original', sa.Boolean(), nullable=False),
    sa.Column('date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.ForeignKeyConstraint(['contract_id'], ['documents.contract.id'], name=op.f('agreement_contract__contract_id__fk'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name=op.f('agreement__pk')),
    schema='documents'
    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('agreement', schema='documents')
    # ### end Alembic commands ###
