"""yadoc_id

Revision ID: 6c16b8748124
Revises: 09d52d03f63b
Create Date: 2022-02-24 01:20:11.911174+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '6c16b8748124'
down_revision = '09d52d03f63b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('act', sa.Column('yadoc_id', sa.BigInteger(), nullable=True), schema='documents')
    op.alter_column('contract', 'created_at',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=False,
               existing_server_default=sa.text('now()'),
               schema='documents')
    op.alter_column('contract', 'signing_date',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=True,
               schema='documents')
    op.add_column('invoice', sa.Column('yadoc_id', sa.BigInteger(), nullable=True), schema='documents')
    op.add_column('factura', sa.Column('yadoc_id', sa.BigInteger(), nullable=True), schema='documents')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('invoice', 'yadoc_id', schema='documents')
    op.alter_column('contract', 'signing_date',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=False,
               schema='documents')
    op.alter_column('contract', 'created_at',
               existing_type=postgresql.TIMESTAMP(timezone=True),
               nullable=True,
               existing_server_default=sa.text('now()'),
               schema='documents')
    op.drop_column('act', 'yadoc_id', schema='documents')
    op.drop_column('factura', 'yadoc_id', schema='documents')
    # ### end Alembic commands ###
