import asyncio
import logging.config

from gino.dialects.asyncpg import Pyscopg2Pool

from crm.agency_cabinet.documents.common import QUEUE
from crm.agency_cabinet.documents.server.src.config import DocumentsConfig
from crm.agency_cabinet.documents.server.src.db.engine import db
from crm.agency_cabinet.documents.server.src.handler import Handler
from crm.agency_cabinet.documents.server.src.config import YADOC_CONFIG, DocumentsTvm2Config
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.common.server.common.logging_config import get_logging_config
from crm.agency_cabinet.common.monitoring.utils.server import run_ping_service
from crm.agency_cabinet.common.monitoring.utils.registry import setup_monitoring

__all__ = ['run_server']


def run_server():
    cfg = DocumentsConfig.from_environ()
    logging.config.dictConfig(get_logging_config(cfg.verbose))

    asyncio.run(_run_server(cfg))


async def _run_server(cfg: DocumentsConfig):
    await db.set_bind(bind=str(cfg.db.get_dsn()), pool_class=Pyscopg2Pool, ssl='verify-full')
    metric_registry = setup_monitoring()
    async with ServiceDiscovery(cfg.amqp_url, with_rpc_client=False) as sd:  # type: ServiceDiscovery
        tvm2_config = DocumentsTvm2Config.from_environ()  # TODO: use one type for config
        handler = Handler(
            YADOC_CONFIG['endpoint_url'],
            YADOC_CONFIG['tvm_id'],
            tvm_config=tvm2_config,
            metric_registry=metric_registry
        )

        async with sd.rpc_server(QUEUE) as server:
            await handler.setup()
            await asyncio.gather(server.drain(handler), run_ping_service(metric_registry))
