from crm.agency_cabinet.common.celery.base import ContextTask, CeleryAppFactoryContextTask
from crm.agency_cabinet.documents.server.src.config import CELERY_SETTINGS, SCHEDULER_LOCK_SETTINGS, db_config
from crm.agency_cabinet.documents.server.src.db import db


class DocumentsContextTask(ContextTask):
    pass


celery_app = CeleryAppFactoryContextTask(
    'documents_tasks',
    scheduler_lock_settings=SCHEDULER_LOCK_SETTINGS,
    celery_settings=CELERY_SETTINGS,
    task_class=DocumentsContextTask,
    db=db,
    db_config=db_config.db
).create()
