import logging

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from yt.wrapper import YtClient

from crm.agency_cabinet.common.yt.loaders import YqlLoader
from .synchronizer import ActsSynchronizer

LOGGER = logging.getLogger('celery.load_acts_info')


class ActsLoader(YqlLoader):
    synchronizer_class = ActsSynchronizer
    YQL_QUERY = '''
        use hahn;

        DECLARE $loading_date AS String;

        SELECT
            act_id as id,
            act_external_id as eid,
            invoice_eid,
            SUM(amount) as amount,
            currency,
            dt,
            contract_id,
        FROM LIKE(`//home/balance/prod/acts/f_sales_daily`, $loading_date)
        WHERE agency_id IS NOT NULL
        AND contract_eid IS NOT NULL
        AND invoice_eid IS NOT NULL
        GROUP BY act_id, act_external_id, invoice_eid, currency, dt, contract_id
        ;
'''

    def __init__(self, yt_client: YtClient, yql_client: YqlClient, table_path: str, loading_date: str):
        super().__init__(
            yt_client, yql_client,
            yql_parameters={
                '$loading_date': YqlParameterValueBuilder.make_string(loading_date)
            },
            table_paths=[table_path + loading_date],
        )

    async def _load(self, *args, **kwargs) -> bool:
        results = await self._get_results()
        data = results.table.get_iterator()
        return await self.synchronizer_class().process_data(data)
