import logging
from datetime import datetime

from crm.agency_cabinet.common.yt.synchronizers import BaseSynchronizer
from crm.agency_cabinet.documents.server.src.db import models


LOGGER = logging.getLogger('celery.tasks.documents.acts.synchronizers')


class ActsSynchronizer(BaseSynchronizer):
    async def process_data(self, rows: list[tuple], *args, **kwargs) -> bool:
        # row: id, eid, invoice_eid, amount, currency, dt, contract_id
        for row in rows:
            duplicate = await self._is_duplicate(row[0])
            contract = await self._is_contract_present(row[6])
            invoice = await self._get_invoice(row[2])

            if not duplicate and contract and invoice:
                date = datetime.strptime(row[5], '%Y-%m-%d') if row[5] else None
                await models.Act.create(
                    id=row[0],
                    eid=row[1],
                    invoice_id=invoice.id,
                    amount=row[3],
                    currency=row[4],
                    date=date,
                )
        return True

    async def _is_duplicate(self, row_id):
        invoice = await models.Act.query.where(models.Act.id == row_id).gino.first()
        return bool(invoice)

    async def _is_contract_present(self, contract_id):
        contract = await models.Contract.query.where(models.Contract.id == contract_id).gino.first()
        return bool(contract)

    async def _get_invoice(self, eid):
        return await models.Invoice.query.where(models.Invoice.eid == eid).gino.first()
