import logging

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from yt.wrapper import YtClient

from crm.agency_cabinet.common.consts import START_FIN_YEAR_2021
from crm.agency_cabinet.common.yt.loaders import YqlLoader
from .synchronizer import ContractsSynchronizer

LOGGER = logging.getLogger('celery.load_contracts_info')


class ContractsLoader(YqlLoader):
    synchronizer_class = ContractsSynchronizer
    YQL_QUERY = '''
        use hahn;
        pragma yson.AutoConvert;
        pragma yson.DisableStrict;

        DECLARE $contract_table_name AS String;
        DECLARE $person_table_name AS String;
        DECLARE $contract_apex_table_name AS String;
        DECLARE $dt AS String;


        SELECT
            ID AS id,
            Yson::LookupInt64(Object, 'client_id') AS agency_id,
            Yson::LookupString(Object, 'external_id') AS eid,
            Yson::LookupDict(Object, 'collaterals') AS collaterals,
            inn
        FROM $contract_table_name AS contracts
        LEFT JOIN $contract_apex_table_name AS apex_contracts ON (apex_contracts.contract_id = contracts.ID)
        LEFT JOIN $person_table_name AS t_person ON (t_person.id = Yson::LookupInt64(contracts.Object, 'person_id'))
        WHERE
            Yson::LookupBool(Yson::Lookup(Yson::Lookup(Object, 'collaterals'), '0'), 'is_cancelled')==false
            AND (
                Yson::LookupInt64(Yson::Lookup(Yson::Lookup(Object, 'collaterals'), '0'), 'fake_id')==0
                OR
                Yson::LookupInt64(Yson::Lookup(Yson::Lookup(Object, 'collaterals'), '0'), 'fake_id') is null
            )
            AND (
                finish_dt > $dt
                OR
                end_dt > $dt
            )
        ;
        '''

    def __init__(self, yt_client: YtClient, yql_client: YqlClient, table_path: str):
        super().__init__(
            yt_client, yql_client,
            yql_parameters={
                '$contract_table_name': YqlParameterValueBuilder.make_string(
                    '//home/balance/prod/contracts/contracts_json'),
                '$person_table_name': YqlParameterValueBuilder.make_string('//home/balance/prod/bo/t_person'),
                '$contract_apex_table_name': YqlParameterValueBuilder.make_string(
                    '//home/balance/prod/bo/v_contract_apex_full'),
                '$dt': YqlParameterValueBuilder.make_string(START_FIN_YEAR_2021.strftime('%Y-%m-%dT%H:%M:%S'))
            },
            table_paths=[table_path],
        )

    async def _load(self, *args, **kwargs) -> bool:
        results = await self._get_results()
        data = results.table.get_iterator()
        return await self.synchronizer_class().process_data(data)
