import logging

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from yt.wrapper import YtClient

from crm.agency_cabinet.common.yt.loaders import YqlLoader
from .synchronizer import FacturesSynchronizer

LOGGER = logging.getLogger('celery.load_facture_info')


class FacturesLoader(YqlLoader):
    synchronizer_class = FacturesSynchronizer
    YQL_QUERY = '''
        use hahn;

        DECLARE $loading_date AS String;

        SELECT
            CAST(factura AS Uint64) as id,
            invoice_eid,
            (SUM(amount) - SUM(amount_nds)) as amount,
            SUM(amount) as amount_with_nds,
            SUM(amount_nds) as nds,
            currency,
            dt,
            act_id,
        FROM LIKE(`//home/balance/prod/acts/f_sales_daily`, $loading_date)
        WHERE agency_id IS NOT NULL
        AND invoice_eid IS NOT NULL
        AND factura != '0'
        GROUP BY factura, invoice_eid, currency, dt, act_id
        ;
    '''

    def __init__(self, yt_client: YtClient, yql_client: YqlClient, table_path: str, loading_date: str):
        super().__init__(
            yt_client, yql_client,
            yql_parameters={
                '$loading_date': YqlParameterValueBuilder.make_string(loading_date)
            },
            table_paths=[table_path],
        )

    async def _load(self, *args, **kwargs) -> bool:
        results = await self._get_results()
        data = results.table.get_iterator()
        return await self.synchronizer_class().process_data(data)
