import logging
from datetime import datetime

from crm.agency_cabinet.common.yt.synchronizers import BaseSynchronizer
from crm.agency_cabinet.documents.server.src.db import models


LOGGER = logging.getLogger('celery.tasks.documents.factures.synchronizers')


class FacturesSynchronizer(BaseSynchronizer):
    async def process_data(self, rows: list[tuple], *args, **kwargs) -> bool:
        # row: id, invoice_eid, amount, amount_with_nds, nds, currency, dt, act_external_id
        for row in rows:
            duplicate = await self._is_duplicate(row[0])
            invoice = await self._get_invoice(row[1])
            act = await self._get_act(row[7])

            if not duplicate and invoice and act:
                date = datetime.strptime(row[6], '%Y-%m-%d') if row[6] else None
                await models.Facture.create(
                    id=row[0],
                    invoice_id=invoice.id,
                    act_id=act.id,
                    amount=row[2],
                    amount_with_nds=row[3],
                    nds=row[4],
                    currency=row[5],
                    date=date,
                )
        return True

    async def _is_duplicate(self, row_id):
        invoice = await models.Facture.query.where(models.Facture.id == row_id).gino.first()
        return bool(invoice)

    async def _get_invoice(self, invoice_eid):
        return await models.Invoice.query.where(models.Invoice.eid == invoice_eid).gino.first()

    async def _get_act(self, act_id):
        return await models.Act.query.where(models.Act.id == act_id).gino.first()
