import logging

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from yt.wrapper import YtClient

from crm.agency_cabinet.common.yt.loaders import YqlLoader
from .synchronizer import InvoicesSynchronizer

LOGGER = logging.getLogger('celery.load_invoice_info')


class InvoicesLoader(YqlLoader):
    synchronizer_class = InvoicesSynchronizer
    YQL_QUERY = '''
    use hahn;

    DECLARE $start_date AS String;
    DECLARE $end_date AS String;

    SELECT
        id,
        contract_id,
        external_id,
        dt,
        iso_currency,
        receipt_dt,
        amount,
        receipt_sum,
        payment_date
    FROM `//home/balance/prod/invoices/t_invoice`
    WHERE contract_id IS NOT NULL
    AND amount IS NOT NULL
    AND dt BETWEEN $start_date AND $end_date
    ;
    '''

    def __init__(self, yt_client: YtClient, yql_client: YqlClient, table_path: str, start_date: str, end_date: str):
        super().__init__(
            yt_client, yql_client,
            yql_parameters={
                '$start_date': YqlParameterValueBuilder.make_string(start_date),
                '$end_date': YqlParameterValueBuilder.make_string(end_date)
            },
            table_paths=[table_path],
        )

    async def _load(self, *args, **kwargs) -> bool:
        results = await self._get_results()
        data = results.table.get_iterator()
        return await self.synchronizer_class().process_data(data)

    async def _is_should_execute(self):
        return True
