import logging
from datetime import datetime

from crm.agency_cabinet.documents.common.structs import InvoiceStatus
from crm.agency_cabinet.common.yt.synchronizers import BaseSynchronizer
from crm.agency_cabinet.documents.server.src.db import models


LOGGER = logging.getLogger('celery.tasks.documents.invoices.synchronizers')


class InvoicesSynchronizer(BaseSynchronizer):
    async def process_data(self, rows: list[tuple], *args, **kwargs) -> bool:
        # row: id, contract_id, external_id, dt, iso_currency, receipt_dt, amount, receipt_sum, payment_date
        for row in rows:
            duplicate = await self._is_duplicate(row[0])
            contract_present = await self._is_contract_present(row[1])

            if not duplicate and contract_present:
                status = InvoiceStatus.paid.value if row[7] >= row[6] else InvoiceStatus.not_paid.value
                date = datetime.strptime(row[3], '%Y-%m-%dT%H:%M:%SZ')
                payment_date = datetime.strptime(row[8], '%Y-%m-%d') if row[5] and row[8] else None
                await models.Invoice.create(
                    id=row[0],
                    contract_id=row[1],
                    eid=row[2],
                    date=date,
                    payment_date=payment_date,
                    currency=row[4],
                    amount=row[6],
                    status=status,
                )
        return True

    async def _is_duplicate(self, row_id):
        invoice = await models.Invoice.query.where(models.Invoice.id == row_id).gino.first()
        return bool(invoice)

    async def _is_contract_present(self, contract_id):
        contract = await models.Contract.query.where(models.Contract.id == contract_id).gino.first()
        return bool(contract)
