import logging

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from yt.wrapper import YtClient

from crm.agency_cabinet.common.yt.loaders import YqlLoader
from .synchronizer import PaymentsSynchronizer

LOGGER = logging.getLogger('celery.load_payments_info')


class PaymentsLoader(YqlLoader):
    synchronizer_class = PaymentsSynchronizer
    YQL_QUERY = '''
        use hahn;
        PRAGMA AnsiInForEmptyOrNullableItemsCollections;

        DECLARE $start_date AS String;
        DECLARE $end_date AS String;

        SELECT
            payment_number as eid,
            amount,
            payment_date as date,
            receipt_number as invoice_eid,
        FROM `//home/balance/prod/bo/t_oebs_cash_payment_fact`
        WHERE payment_date is not NULL
        AND operation_type not in ('SF_AVANS', 'ACTIVITY')
        AND receipt_number is not null
        AND payment_number is not null
        AND payment_date BETWEEN $start_date AND $end_date
        ;
    '''

    def __init__(self, yt_client: YtClient, yql_client: YqlClient, table_path: str, start_date: str, end_date: str):
        super().__init__(
            yt_client, yql_client,
            yql_parameters={
                '$start_date': YqlParameterValueBuilder.make_string(start_date),
                '$end_date': YqlParameterValueBuilder.make_string(end_date)
            },
            table_paths=[table_path],
        )

    async def _load(self, *args, **kwargs) -> bool:
        results = await self._get_results()
        data = results.table.get_iterator()
        return await self.synchronizer_class().process_data(data)

    async def _is_should_execute(self):
        return True
